/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import vswe.stevesfactory.blocks.ClusterMethodRegistration;
import vswe.stevesfactory.blocks.ClusterRegistry;
import vswe.stevesfactory.blocks.ITileEntityInterface;
import vswe.stevesfactory.blocks.TileEntityCamouflage;
import vswe.stevesfactory.blocks.TileEntityClusterElement;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.IPacketBlock;
import vswe.stevesfactory.network.PacketHandler;

public class TileEntityCluster
extends TileEntity
implements ITileEntityInterface,
IPacketBlock {
    private boolean requestedInfo;
    private List<TileEntityClusterElement> elements = new ArrayList<TileEntityClusterElement>();
    private List<ClusterRegistry> registryList = new ArrayList<ClusterRegistry>();
    private Map<ClusterMethodRegistration, List<Pair>> methodRegistration = new HashMap<ClusterMethodRegistration, List<Pair>>();
    private ITileEntityInterface interfaceObject;
    private TileEntityCamouflage camouflageObject;
    private static final String NBT_SUB_BLOCKS = "SubBlocks";
    private static final String NBT_SUB_BLOCK_ID = "SubId";
    private static final String NBT_SUB_BLOCK_META = "SubMeta";

    public TileEntityCluster() {
        for (ClusterMethodRegistration clusterMethodRegistration : ClusterMethodRegistration.values()) {
            this.methodRegistration.put(clusterMethodRegistration, new ArrayList());
        }
    }

    public void loadElements(ItemStack itemStack) {
        NBTTagCompound compound = itemStack.func_77978_p();
        if (compound != null && compound.func_74764_b("Cable")) {
            NBTTagCompound cable = compound.func_74775_l("Cable");
            byte[] types = cable.func_74770_j("Types");
            this.loadElements(types);
        }
    }

    private void loadElements(byte[] types) {
        this.registryList.clear();
        this.elements.clear();
        for (byte type : types) {
            ClusterRegistry block = ClusterRegistry.getRegistryList().get(type);
            this.registryList.add(block);
            TileEntityClusterElement element = (TileEntityClusterElement)block.getBlock().func_149915_a(this.func_145831_w(), 0);
            this.elements.add(element);
            if (element instanceof ITileEntityInterface) {
                this.interfaceObject = (ITileEntityInterface)((Object)element);
            } else if (element instanceof TileEntityCamouflage) {
                this.camouflageObject = (TileEntityCamouflage)element;
            }
            for (ClusterMethodRegistration clusterMethodRegistration : element.getRegistrations()) {
                this.methodRegistration.get((Object)clusterMethodRegistration).add(new Pair(block, element));
            }
            element.field_145851_c = this.field_145851_c;
            element.field_145848_d = this.field_145848_d;
            element.field_145849_e = this.field_145849_e;
            element.func_145834_a(this.field_145850_b);
            element.setPartOfCluster(true);
        }
    }

    public List<TileEntityClusterElement> getElements() {
        return this.elements;
    }

    public void func_145845_h() {
        for (TileEntityClusterElement element : this.elements) {
            this.setWorldObject(element);
            element.func_145845_h();
        }
        if (!this.requestedInfo && this.field_145850_b.field_72995_K) {
            this.requestedInfo = true;
            this.requestData();
        }
    }

    public void setWorldObject(TileEntityClusterElement te) {
        if (!te.func_145830_o()) {
            te.func_145834_a(this.field_145850_b);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void requestData() {
        PacketHandler.sendBlockPacket(this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 1);
    }

    public List<Pair> getRegistrations(ClusterMethodRegistration method) {
        return this.methodRegistration.get((Object)method);
    }

    public void onBlockPlacedBy(EntityLivingBase entity, ItemStack itemStack) {
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.ON_BLOCK_PLACED_BY)) {
            this.setWorldObject(blockContainer.te);
            blockContainer.registry.getBlock().func_149689_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, entity, blockContainer.registry.getItemStack());
        }
    }

    public void onNeighborBlockChange(Block block) {
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.ON_NEIGHBOR_BLOCK_CHANGED)) {
            this.setWorldObject(blockContainer.te);
            blockContainer.registry.getBlock().func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, block);
        }
    }

    public boolean canConnectRedstone(int side) {
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.CAN_CONNECT_REDSTONE)) {
            this.setWorldObject(blockContainer.te);
            if (!blockContainer.registry.getBlock().canConnectRedstone((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side)) continue;
            return true;
        }
        return false;
    }

    public void onBlockAdded() {
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.ON_BLOCK_ADDED)) {
            this.setWorldObject(blockContainer.te);
            blockContainer.registry.getBlock().func_149726_b(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean shouldCheckWeakPower(int side) {
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.SHOULD_CHECK_WEAK_POWER)) {
            this.setWorldObject(blockContainer.te);
            if (!blockContainer.registry.getBlock().shouldCheckWeakPower((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side)) continue;
            return true;
        }
        return false;
    }

    public int isProvidingWeakPower(int side) {
        int max = 0;
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.IS_PROVIDING_WEAK_POWER)) {
            this.setWorldObject(blockContainer.te);
            max = Math.max(max, blockContainer.registry.getBlock().func_149709_b((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side));
        }
        return max;
    }

    public int isProvidingStrongPower(int side) {
        int max = 0;
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.IS_PROVIDING_STRONG_POWER)) {
            this.setWorldObject(blockContainer.te);
            max = Math.max(max, blockContainer.registry.getBlock().func_149748_c((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side));
        }
        return max;
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        for (Pair blockContainer : this.getRegistrations(ClusterMethodRegistration.ON_BLOCK_ACTIVATED)) {
            this.setWorldObject(blockContainer.te);
            if (!blockContainer.registry.getBlock().func_149727_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, player, side, hitX, hitY, hitZ)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getTileEntity(Class<? extends TileEntityClusterElement> clazz, IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null) {
            if (clazz.isInstance(te)) {
                return (T)te;
            }
            if (te instanceof TileEntityCluster) {
                for (TileEntityClusterElement element : ((TileEntityCluster)te).getElements()) {
                    if (!clazz.isInstance((Object)element)) continue;
                    return (T)((Object)element);
                }
            }
        }
        return null;
    }

    @Override
    public Container getContainer(TileEntity te, InventoryPlayer inv) {
        return this.interfaceObject == null ? null : this.interfaceObject.getContainer((TileEntity)this.interfaceObject, inv);
    }

    @Override
    public GuiScreen getGui(TileEntity te, InventoryPlayer inv) {
        return this.interfaceObject == null ? null : this.interfaceObject.getGui((TileEntity)this.interfaceObject, inv);
    }

    @Override
    public void readAllData(DataReader dr, EntityPlayer player) {
        if (this.interfaceObject != null) {
            this.interfaceObject.readAllData(dr, player);
        }
    }

    @Override
    public void readUpdatedData(DataReader dr, EntityPlayer player) {
        if (this.interfaceObject != null) {
            this.interfaceObject.readUpdatedData(dr, player);
        }
    }

    @Override
    public void writeAllData(DataWriter dw) {
        if (this.interfaceObject != null) {
            this.interfaceObject.writeAllData(dw);
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList subList = new NBTTagList();
        for (int i = 0; i < this.elements.size(); ++i) {
            TileEntityClusterElement element = this.elements.get(i);
            ClusterRegistry registryElement = this.registryList.get(i);
            NBTTagCompound sub = new NBTTagCompound();
            sub.func_74774_a(NBT_SUB_BLOCK_ID, (byte)registryElement.getId());
            sub.func_74774_a(NBT_SUB_BLOCK_META, (byte)element.func_145832_p());
            element.writeContentToNBT(sub);
            subList.func_74742_a((NBTBase)sub);
        }
        tagCompound.func_74782_a(NBT_SUB_BLOCKS, (NBTBase)subList);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        int i;
        super.func_145839_a(tagCompound);
        NBTTagList subList = tagCompound.func_150295_c(NBT_SUB_BLOCKS, 10);
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        for (int i2 = 0; i2 < subList.func_74745_c(); ++i2) {
            NBTTagCompound sub = subList.func_150305_b(i2);
            bytes.add(sub.func_74771_c(NBT_SUB_BLOCK_ID));
        }
        byte[] byteArr = new byte[bytes.size()];
        for (i = 0; i < bytes.size(); ++i) {
            byteArr[i] = (Byte)bytes.get(i);
        }
        this.loadElements(byteArr);
        for (i = 0; i < subList.func_74745_c(); ++i) {
            NBTTagCompound sub = subList.func_150305_b(i);
            TileEntityClusterElement element = this.elements.get(i);
            element.setMetaData(sub.func_74771_c(NBT_SUB_BLOCK_META));
            element.readContentFromNBT(sub);
        }
    }

    @Override
    public void writeData(DataWriter dw, EntityPlayer player, boolean onServer, int id) {
        if (id == 0) {
            if (this.camouflageObject != null) {
                this.camouflageObject.writeData(dw, player, onServer, id);
            }
        } else if (onServer) {
            int i;
            dw.writeData(this.elements.size(), DataBitHelper.CLUSTER_SUB_ID);
            for (i = 0; i < this.elements.size(); ++i) {
                dw.writeData((int)((byte)this.registryList.get(i).getId()), DataBitHelper.CLUSTER_SUB_ID);
            }
            for (i = 0; i < this.elements.size(); ++i) {
                dw.writeData((int)((byte)this.elements.get(i).func_145832_p()), DataBitHelper.BLOCK_META);
            }
        }
    }

    @Override
    public void readData(DataReader dr, EntityPlayer player, boolean onServer, int id) {
        if (id == 0) {
            if (this.camouflageObject != null) {
                this.camouflageObject.readData(dr, player, onServer, id);
            }
        } else if (onServer) {
            PacketHandler.sendBlockPacket(this, player, 1);
        } else {
            int i;
            int length = dr.readData(DataBitHelper.CLUSTER_SUB_ID);
            byte[] types = new byte[length];
            for (i = 0; i < length; ++i) {
                types[i] = (byte)dr.readData(DataBitHelper.CLUSTER_SUB_ID);
            }
            this.loadElements(types);
            for (i = 0; i < length; ++i) {
                this.elements.get(i).setMetaData(dr.readData(DataBitHelper.BLOCK_META));
            }
        }
    }

    @Override
    public int infoBitLength(boolean onServer) {
        return 1;
    }

    public byte[] getTypes() {
        byte[] bytes = new byte[this.registryList.size()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)this.registryList.get(i).getId();
        }
        return bytes;
    }

    public class Pair {
        private ClusterRegistry registry;
        public TileEntityClusterElement te;

        private Pair(ClusterRegistry registry, TileEntityClusterElement te) {
            this.registry = registry;
            this.te = te;
        }
    }
}

